package LIMS::Model::ErrorCode;

use base 'LIMS::Model::Base';
use strict;

#-------------------------------------------------------------------------------
sub get_error_code {
    my ($self, $code_id) = @_; # $self->debug($code_id);

    my $data = LIMS::DB::ErrorCode->new(id => $code_id)->load;

    return $data;
}

#-------------------------------------------------------------------------------
sub get_report_error_code {
    my ($self, $code_id) = @_; # $self->debug($code_id);

    my $data = LIMS::DB::ReportErrorCode->new(id => $code_id)->load;

    return $data;
}

#-------------------------------------------------------------------------------
sub check_error_code {
    my ($self, $code) = @_; # $self->debug($code_id);

    my $data = LIMS::DB::ErrorCode->new(code => $code)->load(speculative => 1);

    return $data;
}

#-------------------------------------------------------------------------------
sub get_error_codes {
    my $self = shift;
    my $args = shift || {};

    my %args = (
        query   => [ %$args ], # ok for $args to be empty
        sort_by => 'code',
    );
    # get all error_code rows as arrayref:
    my $data = LIMS::DB::ErrorCode::Manager->get_error_codes(%args); # DEBUG $data;

    return $data;
}

#-------------------------------------------------------------------------------
sub get_error_code_assignment {
    my $self = shift;
    my $type = shift;

    my %args = (
        query => [
            type => $type,
        ],
        require_objects => 'error_code',
    );
    
    my $error_codes
        = LIMS::DB::ErrorCodeAssignment::Manager->get_error_code_assigment(%args);
    
    return $error_codes;
}
    
#-------------------------------------------------------------------------------
sub get_report_error_codes {
    my $self = shift;
    my $args = shift || {};

    my %args = (
        query   => [ %$args ], # ok for $args to be empty
        sort_by => 'code',
    );
    # get all report_error_code rows as arrayref:
    my $data = LIMS::DB::ReportErrorCode::Manager->get_report_error_codes(%args); # DEBUG $data;

    return $data;
}

#-------------------------------------------------------------------------------
sub update_error_codes {
    my $self = shift;
    my $data = shift; # $self->debug( $data );
   
    my %args = ( class => 'ErrorCode', data  => $data );
    
    return $self->update_object(\%args);
}

#-------------------------------------------------------------------------------
sub update_error_code_assigmnents {
    my $self = shift;
    my $data = shift; # $self->debug( $data );

    my $db = $self->lims_db; # ie LIMS::DB->new_or_cached;
    
    my $type = $data->{type};
    my @error_code_ids = @{ $data->{error_code_id} };
    
    my $update = sub {
        # first clear existing entries for type:
        LIMS::DB::ErrorCodeAssignment::Manager->delete_error_code_assignment(
#            db    => $db,
            where => [ type => $type ],
        );
        # new entry for each error_code_id:
        foreach(@error_code_ids) {
            LIMS::DB::ErrorCodeAssignment->new(
                type => $type,
                error_code_id => $_,
#                db => $db,
            )->save;
        }
    };
    
    my $ok = $db->do_transaction($update);

    # don't need return value unless error:
    return $ok ? 0 : 'update_error_codes_config() error - ' . $db->error;    
}

#-------------------------------------------------------------------------------
sub update_report_error_codes {
    my $self = shift;
    my $data = shift;  $self->debug( $data );
   
    my %args = ( class => 'ReportErrorCode', data  => $data );
    
    return $self->update_object(\%args);
}

1;
