package LIMS::DB::ReferralSource;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'referral_sources',

    columns => [
        id                     => { type => 'serial', not_null => 1 },
        display_name           => { type => 'varchar', length => 255, not_null => 1 },
        organisation_code      => { type => 'varchar', length => 6, not_null => 1 },
        parent_organisation_id => { type => 'integer', default => '0', not_null => 1 },
        referral_type_id       => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'display_name' ],
        [ 'organisation_code' ],
    ],

    foreign_keys => [
        parent_organisation => {
            class       => 'LIMS::DB::ParentOrganisation',
            key_columns => { parent_organisation_id => 'id' },
        },

        referral_type => {
            class       => 'LIMS::DB::ReferralType',
            key_columns => { referral_type_id => 'id' },
        },
    ],

    relationships => [
        email_contacts => {
            class      => 'LIMS::DB::EmailContact',
            column_map => { id => 'referral_source_id' },
            type       => 'one to many',
        },

        patient_case => {
            class      => 'LIMS::DB::PatientCase',
            column_map => { id => 'referral_source_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('referral_sources');

1;
