#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
use Test::Builder::Tester;

use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 23;
# use Test::More 'no_plan';

=begin: tests:

=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

my $dbix = get_dbix();

$dbix->insert('error_codes', { code => 'd', description => 'record merged',
    is_unique => 'no', active => 'yes' });
{ # add new patient/request - name similar to existing:
    $dbix->insert('patients', { last_name => 'green', first_name => 'alan',
        middle_name => 'michael',  dob => '1940-02-02' }); # different dob
    my $patient_id = get_last_insert_id('patients');
    $dbix->insert('patient_case', { patient_id => $patient_id, referral_source_id => 2,
        unit_number => 1011 });
    my $patient_case_id = get_last_insert_id('patient_case');
    $dbix->insert('requests', { request_number => 3, year => DateTime->now->year,
        patient_case_id => $patient_case_id, referrer_department_id => 1,
        created_at => DateTime->now });
}
{ # insert new patient with no request (orphaned patient record):
    $dbix->insert('patients', { last_name => 'green', first_name => 'alan',
        middle_name => 'michael',  dob => '1940-02-03' }); # different dob
    my $patient_id = get_last_insert_id('patients');
    $dbix->insert('patient_case', { patient_id => $patient_id,
        referral_source_id => 2, unit_number => 1011 });
}

{ # check how many patients called  green (should be 3):
    $dbix->select('patients', 'count(id)', { last_name => 'green' })->into(my $i);
    is($i, 3, 'OK: expected patient count');
}

$mech->get_ok('/admin/patient_merge/search?last_name=green'); # print_and_exit();
{
    $mech->form_name('do_merge');
    # merge patient #3 attached to H3 with patient #1 attached to H1, #3 deleted:
    $mech->submit_form( fields => { 3 => 'from', 1 => 'to' } );# print_and_exit();
    $mech->submit_form();                                      # print_and_exit();

    my $msg = get_messages('patient')->{merge}->{merge_success}; 
    $mech->has_tag_like(        
        p => qr($msg),
        'OK: patient merge successful',
    );                                                        # print_and_exit();
    
    $mech->has_tag(
		td => '01.Feb.1940',
        'OK: expected dob found',
    );

    test_out( 'not ok 1 - foo' );
    test_fail( +1 );
    $mech->has_tag( td => '02.Feb.1940', 'foo' );
    test_test( 'OK: deleted dob not found' );                 # print_and_exit();
}

# THIS SHOULD NOT SHOW EDIT HISTORY (WAS DONE ON RECORD #3):
$mech->get_ok('/history/=/1');                                # print_and_exit();
{ # warn $mech->text();
    my $i = () = $mech->text =~ /record merged/g; # gets instance count
    is($i, 4, 'OK: expected record merge history');
}                                                             # print_and_exit();

{ # check patient edit direct in patients tables:
    $dbix->select('patients', 'count(id)', { last_name => 'green' })->into(my $i);
    is($i, 2, 'OK: expected patient count');
    
    # check patient.id #3 deleted:
    $dbix->select('patients', 'count(id)', { id => 3 })->into(my $n);
    is($n, 0, 'OK: expected patient deleted');
}

$mech->get_ok('/admin/patient_merge/search?last_name=green'); # print_and_exit();
{
    $mech->form_name('do_merge');
    # merge orphaned patient #4 with patient #1 attached to H1 & H3, #4 deleted:
    $mech->submit_form( fields => { 4 => 'from', 1 => 'to' } );# print_and_exit();
    $mech->submit_form();                                      # print_and_exit();
}

{ # check patient edit direct in patients tables:
    $dbix->select('patients', 'count(id)', { last_name => 'green' })->into(my $i);
    is($i, 1, 'OK: expected patient count');
    
    # check patient.id #4 deleted:
    $dbix->select('patients', 'count(id)', { id => 4 })->into(my $n);
    is($n, 0, 'OK: expected patient deleted');
    
    # have checked only 1 'gree', retrieve as hash:
    my $data = $dbix->select('patients', '*', { last_name => 'green' })->hash;
    
    my %patient = (
        first_name => 'alan',
        dob        => '1940-02-01',
        nhs_number => 1111111111,
        gender     => 'M',
        id         => 1,
    );
    for (keys %patient) { # check remaining patient details:
        is( $data->{$_}, $patient{$_}, "OK: patient $_ matches" );
    }
}

# check orphaned patient did not get recorded in history:
$mech->get_ok('/history/=/1');                                # print_and_exit();
{ # warn $mech->text();
    my $i = () = $mech->text =~ /record merged/g; # gets instance count
    is($i, 4, 'OK: expected record merge history');
}                                                             # print_and_exit();
