package LIMS::DB::LabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_tests',

    columns => [
        id             => { type => 'integer', not_null => 1 },
        test_name      => { type => 'varchar', length => 25, not_null => 1 }, # default => '' - SEE 'README'
        field_label    => { type => 'varchar', length => 25, not_null => 1 }, # default => '' - SEE 'README'
        lab_section_id => { type => 'integer', default => '0', not_null => 1 },
        test_type      => { type => 'enum', check_in => [ 'test', 'panel' ] },
        has_results    => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        is_active      => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'test_name', 'lab_section_id', 'test_type' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::DB::LabSection',
            key_columns => { lab_section_id => 'id' },
        },
    ],

    relationships => [
        lab_test_data_type => {
            class                => 'LIMS::DB::LabTestDataType',
            column_map           => { id => 'lab_test_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
            optional             => 1,
        },

        linked_lab_test => {
            class      => 'LIMS::DB::LinkedLabTest',
            column_map => { id => 'linked_test_id' },
            type       => 'one to many',
        },
        
        parent_test_id => {
            class      => 'LIMS::DB::LinkedLabTest',
            column_map => { id => 'parent_test_id' },
            type       => 'one to many',
        },

        panel_lab_test => {
            class      => 'LIMS::DB::PanelLabTest',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        pre_registration_lab_test => {
            class      => 'LIMS::DB::PreRegistrationLabTest',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        request_lab_test_status => {
            class      => 'LIMS::DB::RequestLabTestStatus',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        requests => {
            map_class => 'LIMS::DB::RequestLabTestResult',
            map_from  => 'lab_test',
            map_to    => 'request',
            type      => 'many to many',
        },

        screen_lab_test => {
            class      => 'LIMS::DB::ScreenLabTest',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        specimen_lab_test => {
            class      => 'LIMS::DB::SpecimenLabTest',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_tests');

=begin # README:
* MySQL is broken here - cannot use unique_keys containing cols with default => '' if not supplying val for field - see:
Rose/DB/Object/Loader.pm#GOTCHAS
=cut

1;