package LIMS::DB::ReportErrorCode;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'report_error_codes',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        code        => { type => 'varchar', length => 2 },
        description => { type => 'varchar', length => 255 },
        active	    => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'code' ],

    foreign_keys => [
        error_code => {
            class       => 'LIMS::DB::ErrorCode',
            key_columns => { code => 'code' },
            rel_type    => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('report_error_codes');

1;
