package LIMS::Controller::Local::Worklist::FishWorksheetCustom;

use base 'LIMS::Base';

use Moose;
with(
    'LIMS::Controller::Roles::Misc',    'LIMS::Controller::Roles::User',
    'LIMS::Controller::Roles::DataMap', 'LIMS::Local::Role::Worklist',
    'LIMS::Controller::Roles::FormData',
);

has 'tt_name' => ( is => 'rw', isa => 'Str' );
__PACKAGE__->meta->make_immutable( inline_constructor => 0 );

use Data::Dumper;
use File::Basename qw(basename);
use URI::Escape qw( uri_unescape);
use Ref::Util 'is_arrayref'; # dont do ref $foo eq 'ARRAY'

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift;
    # get CGI parameters
    my $data =
      $self->get_data_from_dfv( $self->validate('fish_custom_worklist') );
    if ( not exists $data->{request_id} or not exists $data->{template} ) {
        my $url = $self->query->url()
          . '/local_worklist?function_name=fish_worksheets_custom';
        return $self->redirect($url);
    }
    my @request_ids =
      is_arrayref( $data->{request_id} )
      ? @{ $data->{request_id} }
      : ( $data->{request_id} );
    my $template    = uri_unescape( $data->{template} );

    # check only allowed characters in template filename and template found
    my @template_names =
      map { basename $_ } $self->get_fish_custom_template_names;
    if ( $template =~ m{\A([\w ./-]+)\z}mxs
        and grep { $template eq $_ } @template_names )
    {
        $self->tt_params( fish_template => $template );
    }
    else {
        die "invalid template parameter: $template"
          ;    # will only get here if bypassing form
    }

    {
        # get request & report data for request_ids:
        my %args = (    # to use existing method used by Search function
            search_constraints => { id => \@request_ids },
        );              # warn Dumper \%args;
        my $requests = $self->model('Request')->find_requests( \%args );
        $self->tt_params( requests => $requests );    # warn Dumper $requests;
    }

    {    # get lab-test data from FISH section:
        my %args = (
            section_name => 'FISH',
            request_id   => \@request_ids,
            status_option_id => 1,
        );
        my $request_lab_tests =
          $self->model('LabTest')->get_request_lab_tests_for_section( \%args );

        # get probesets for fish panels:
        my $probes =
          $self->_get_fish_panel_probes_as_test_names();  # warn Dumper $probes;
        $self->tt_params( panel_probes => $probes );

        # prepare data here before sending to template
        # [{rid => [ probes, ],}
        my $template_data = {};
        foreach ( grep { $_->status->description !~ /complete|delete/ } @{$request_lab_tests} ) {
            my @tests;
            if ( $_->lab_test->test_type eq 'panel' ) {

                # push panel tests onto @test
                if ( exists $probes->{ $_->lab_test->test_name } )
                {    # not all probes have tests
                    push @tests, @{ $probes->{ $_->lab_test->test_name } };
                }
            }
            else {
                push @tests, $_->lab_test->test_name;
            }

            # build template_data->{rid}->[]
            push @{ $template_data->{ $_->request_id } }, @tests;
        }
        $self->tt_params( template_data => $template_data );
    }

    return $self->render_view(
        'worklist/local/fish/custom_templates_wrapper.tt');
}

1;
