package LIMS::DB::Login;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'logins',

    columns => [
        id         => { type => 'serial',   not_null => 1 },
        user_id    => { type => 'integer',  default => '0', not_null => 1 },
        address    => { type => 'varchar',  length => 15 },
        browser    => { type => 'varchar',  length => 255 },
        session_id => { type => 'character', length => 32 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('logins');

1;
