package LIMS::Model::Option;

use base 'LIMS::Model::Base';

use strict;

# -------------------------------------------------------------------------------------
sub get_consent_options {
    my $self = shift;
    
    my $consent_opts = LIMS::DB::ConsentOption::Manager
        ->get_consent_options( sort_by => 'consent_name' );
    
    return $consent_opts;
}

# -------------------------------------------------------------------------------------
sub get_consent_option {
    my ($self, $consent_id) = @_;
    
    my $consent_opt = LIMS::DB::ConsentOption->new( id => $consent_id )->load;
    
    return $consent_opt;
}

# ------------------------------------------------------------------------------
sub update_consent_options {
    my $self = shift;
    my $data = shift; # $self->debug( $data );

    my %args = ( class => 'ConsentOption', data => $data );
    
    return $self->update_object(\%args);    
}

# -------------------------------------------------------------------------------------
sub get_status_options {
    my $self = shift;
    
    my $status_opts = LIMS::DB::StatusOption::Manager
        ->get_status_options( sort_by => 'description' );
    
    return $status_opts;
}

# -------------------------------------------------------------------------------------
sub get_status_option {
    my ($self, $option_id) = @_;
    
    my $status_opt = LIMS::DB::StatusOption->new( id => $option_id )->load;
    
    return $status_opt;
}

# ------------------------------------------------------------------------------
sub update_status_options {
    my $self = shift;
    my $data = shift; # $self->debug( $data );

    my %args = ( class => 'StatusOption', data => $data );
    
    return $self->update_object(\%args);    
}

1;