package LIMS::Local::EmailAlert;

use Moose;
extends 'LIMS::Local::LIMS'; # provides LIMS methods for cron scripts
with (
    'LIMS::Controller::Roles::DataMap',
    'LIMS::Controller::Roles::RecordHandler', # send_email_alert(), get_single_request_data()
);
__PACKAGE__->meta->make_immutable;

# takes functionality from C::Request::email_alert() to prepare data for
# C::Roles::RecordHandler::send_email_alert()
sub email_alert {
	my $self = shift;	
    my $args = shift;
    
    my $request_id = $args->{request_id};    
	my $mdt_centre = $args->{mdt_centre}; # Airedale, Bradford, Leeds, etc

	my $request_data = $self->get_single_request_data($request_id);
	# stash request_data for send_email_alert():
	$self->stash(request_data => $request_data);
	
    my $rtn = $self->send_email_alert($mdt_centre); # C::Roles::RecordHandler method
    return $rtn;
}

1;