package LIMS::DB::RequestReport;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'request_report',

    columns => [
        request_id       => { type => 'integer', not_null => 1 },
        comment          => { type => 'text', length => 65535 },
        clinical_details => { type => 'text', length => 65535 },
        status           => { type     => 'enum', check_in => [ 'new', 'relapse', 'default' ],
            default  => 'default', not_null => 1, },
        specimen_quality => { type     => 'enum', check_in => [ 'good', 'adequate', 'poor' ],
            default  => 'adequate', not_null => 1, },
        diagnosis_id     => { type => 'integer', not_null => 1 },
        updated_at       => { type => 'timestamp', not_null => 1 },
        created_at       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { diagnosis_id => 'id' },
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

#__PACKAGE__->meta->table('request_report');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 4);

__PACKAGE__->meta->make_manager_class('request_report');

1;
