package LIMS::Model::Validation;

use base 'LIMS::Model::Base';

use strict;

# ------------------------------------------------------------------------------
# checks that submitted form param belongs to record under edit:
# 1st arg (col_name) needs to be arrayref if unique key is multi-col, 
sub validate_param_ownership { # warn 'here';
    my $self = shift;
    my $args = shift; # $self->debug($args);
    
    # check all required args exist & put into array:
    my @required = map {
        $args->{$_} || die "value for \$args->{$_} is required";
    } qw(col class data);

    my ($col_name, $class_name, $data) = @required;

    my %query;
    
    # if $col_name is arrayref:
    if ( ref $col_name eq 'ARRAY' ) {
        %query = map {
            $_ => $data->{$_};
        } @$col_name;
    }
    else {
        %query = ( $col_name => $data->{$col_name} );
    } # $self->debug(\%query);

    my $object_class = 'LIMS::DB::'.$class_name;

#$self->set_rose_debug(1);
    my $o = $object_class->new(%query)->load(speculative => 1);
#$self->set_rose_debug(0);
    $o || return 1; # warn $o->id . ' cmp ' . $data->{_record_id};

    # param *is* in use, so check it belongs to current record id
    # return true only if param.id == data.param_id:        
    return ( $o->id == $data->{_record_id} );    
}

# ------------------------------------------------------------------------------
sub has_storage_vialId { # just need to know if it exists:
    my ($self, $id) = @_;
    
    my $i = LIMS::DB::RequestStorage::Manager
        ->get_objects_count( query => [ vialId => $id ] );
    return $i; # will be 1 or 0
}

1;
