package LIMS::DB::LabTestResultOption;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_test_result_options',

    columns => [
        id           => { type => 'serial', not_null => 1 },
        data_type_id => { type => 'integer', default => '0', not_null => 1 },
        value        => { type => 'varchar', length => 30, not_null => 1 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'data_type_id', 'value' ],
    
    foreign_keys => [
        data_type => {
            class       => 'LIMS::DB::LabTestResultDataType',
            key_columns => { data_type_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_test_result_options');

1;
