#!/usr/bin/perl

use strict;
use warnings;

use lib '/home/raj/perl5/lib/perl5';
use Data::Dumper;

use FindBin qw($Bin); # warn $Bin;
use lib "$Bin/../../../lib";
use LIMS::Local::ScriptHelpers;

#-------------------------------------------------------------------------------
# only needed for SuSE, can be deleted after:
unless (@ARGV) {
	$ARGV[0] = 'leeds';
}
#-------------------------------------------------------------------------------

my %db = (
	leeds => 'hilis4',
	cambridge => 'cambridge_lims',
);

use constant DELTA => 6; # months since last login to inactivate account

my $tools = LIMS::Local::ScriptHelpers->new();

# get tools from LIMS::Local::ScriptHelpers:
my $sql_lib = $tools->sql_lib();
my $dbix    = $tools->dbix();
my $dbh     = $dbix->dbh();

# get sql statments:
my $sql = $sql_lib->retr( 'expire_user_accounts' ); # warn $sql; warn DELTA; exit;

for (@ARGV) { # print $fh Dumper $_;
	my $i = 0; # numerical return from dbh->do()
	
	$dbh->do( 'use '.$db{$_} ); # switch db

	# execute query:
	$i += $dbh->do($sql, undef, DELTA); # warn Dumper $i;
	
	if ($i) {
		my $filename = $tools->script_filename;
		print "$filename inactivated $i $_ accounts\n";
	}
}