package LIMS::DB::LocalNetworkLocation;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'local_network_locations',

    columns => [
        parent_id  => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'parent_id' ],

    foreign_keys => [
        parent_organisation => {
            class       => 'LIMS::DB::ParentOrganisation',
            key_columns => { parent_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('local_network_locations');

1;