package LIMS::Controller::Admin::Config::ReportErrorCodes;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# -------------------------------------------------------------------------------------
startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode);

	my $error_codes = $self->model('ErrorCode')->get_error_codes;
	my $report_error_codes = $self->model('ErrorCode')->get_report_error_codes;
	
	# codes already in use:
	my %codes_map = map {
		$_->code => 1,
	} @$report_error_codes;
	
    $self->tt_params(
		codes_map   => \%codes_map,
		error_codes => $error_codes,
		report_error_codes => $report_error_codes,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('error_codes');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
    $self->_debug_path($self->get_current_runmode); # $self->stash(errs => $errs);

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('ErrorCode')->get_report_error_code($id);

    $self->tt_params( data => $data );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('report_error_code');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

	# if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('report_error_code') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) {
		$data->{id} = $id;
	}

    my $rtn = $self->model('ErrorCode')->update_report_error_codes($data); # warn $rtn;

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/config/report-error-codes' );
}

1;