package LIMS::Controller::Roles::Storage;

use POSIX;
use Moose::Role;
use Data::Printer alias => 'p';

# calculates location of rack and tray according to location specification:
sub auto_location {
    my ($self, $base_location) = @_;

    my $i = do {
        my $q = [ storage_location => { like => $base_location . '%' } ];
        $self->model('Base')->get_objects_count('StorageRack', { query => $q });
    }; # p $i;

    if ( $self->cfg('settings')->{'_centre'} eq 'leeds' ) {
        # see scripts/test_scripts/storage_locations.pl for calculations
        my $rack = floor($i / 36) + 1; # p $rack;
        my $tray = floor($i % 36 /  4) + 1; # p $tray;

        if ( $base_location eq 'Archive' ) { # replace rack number with letter:
            my $letter = 'A'; # start at A and auto-increment, a ..z, aa, ab, etc
            $letter++ while --$rack; # p $letter;
            $rack = $letter;
        }
        return join '/', $base_location, $rack, $tray;
    }
    # else { return join '/', $base_location, ++$i }
    return $base_location; # will be free-text box
}

1;
