package LIMS::DB::UserRegistration;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'user_registration',

    columns => [
        user_id             => { type => 'integer', not_null => 1 },
        registration_number => { type => 'varchar', length => 8 },
    ],

    primary_key_columns => [ 'user_id' ],

    foreign_keys => [
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('user_registrations');

1;
