function form_to_queryparam (form_id, fields, additionals) {
    var form  = document.getElementById(form_id);
    var param = [];    

    for (var add_name in additionals) {
        param.push(add_name + '=' + encodeURIComponent(additionals[ add_name ]));
    }

    for (var field_idx in fields) {
        var elem = form[ fields[ field_idx ] ];
        var value;    
        // encode text inputs
        if (elem.type == 'text') {
            value = elem.value;
        }
        // encode checkboxes
        else if (elem.type == 'checkbox') {
            if (elem.checked) {
                value = elem.value;
            }
            else {
                value = '';
            }
        }
        // encode select boxes
        else if (elem.options) {
            for (var option_idx in elem.options) {
                var opt = elem.options[ option_idx ];     
                if (!opt.selected)
                    continue;
                    param.push(elem.name + '=' + encodeURIComponent(opt.value));
            }
            continue;
        }
        param.push(elem.name + '=' + encodeURIComponent(value));                
    }
    
    return param.join('&');
}
