package LIMS::Controller::Roles::Dashboard;

use Moose::Role;

has dashboard_data => (
	is  	=> 'ro',
	isa 	=> 'HashRef',
	traits  => ['Hash'],
	default => sub { {} },
	handles => { set_dashboard_data => 'set' }, 
);

sub dashboard_view {
    my $self = shift;
    
    { # urgent
        my %args = ( status_query => 'urgent' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( urgent => $n );
    }
    { # unscreened
        my %args = ( status_query => 'unscreened' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unscreened => $n );
    }
    { # unreported
        my %args = (
            status_query => 'unreported',
            duration     => $self->cfg('settings')->{unreported_duration},
        ); # warn Dumper \%args;
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unreported => $n );
    }
    { # unreported, tests_completed
        my %args = ( status_query => 'tests_completed' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( tests_completed => $n );
    }
    { # unauthorised
        my %args = ( status_query => 'unauthorised' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unauthorised => $n );
    }
    { # authorised incomplete
        my %args = ( status_query => 'incomplete' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( incomplete => $n );
    }
    { # incomplete lab-tests:
        my $data = $self->model('LabTest')->get_incomplete_lab_tests();
        $self->set_dashboard_data( incomplete_section_tests => $data );
    }
}

1;
