#!/usr/bin/env perl

# mod_cgi instance script for FileUploader::RequestForms module:

use strict;
use warnings;

use lib (
    '/home/raj/perl5/lib/perl5',
    '/home/raj/apps/FileUploader/lib',
);

use FindBin qw($RealBin);  # load AFTER local::lib Carp or FindBin loads system
use lib $RealBin . '/../../lib'; # HILIS4 lib

BEGIN { # capture centre var for lims_config.pl to load correct file path:
    use LIMS::Local::Utils;
    use FileUploader::Debug;
    use CGI qw(param);

    if ( my $tkn = param('tkn') ) { # DEBUG $tkn;
        my $key = LIMS::Local::Utils::today->ymd; # so url only valid on same day
        my $centre = LIMS::Local::Utils::decrypt($tkn, $key);
        $ENV{CENTRE} = $centre;
    }
    # env CENTRE var *must* exist or lims_config defaults to 'leeds':
    $ENV{CENTRE} ||= 'centre_null_invalid'; # causes config load failure so upload stops
} # DEBUG \%ENV;

#BEGIN { # don't use these with plack
    # Error handlers:
    # $SIG{__WARN__} = sub { require Carp; Carp::cluck(@_) }; # warnings with stack trace to log
    # use CGI::Carp qw(fatalsToBrowser);
    # use CGI::HTMLError trace => 1;
	# use CGI::Carp::DebugScreen;
    # $SIG{__WARN__} = sub { CORE::die(@_) };
    # use Carp::Always;
    # $SIG{ __DIE__ } = sub { Carp::confess( @_ ) };
#}

#==============================================================================
# ErrorHandler's global $SIG{__DIE__} causes problems in File::stat in Perl 5.14
use File::stat (); # <= so call it *before* FileUploader::ErrorHandler
use FileUploader::ErrorHandler; # or better still - replace with plack middleware
#==============================================================================

use FileUploader::RequestForms;
use Data::Dumper;

my %args = (
    PARAMS => {
        cfg_file  => '/home/raj/apps/FileUploader/lib/config.pl',
        file_type => 'request_forms',
    },
);
FileUploader::RequestForms->new(%args)->run;
