package LIMS::DB::Specimen;

use strict;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'specimens',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        sample_code => { type => 'varchar', length => 4 },
        description => { type => 'varchar', length => 40 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'sample_code' ],

    relationships => [
        request_specimen => {
            class      => 'LIMS::DB::RequestSpecimen',
            column_map => { id => 'specimen_id' },
            type       => 'one to many',
        },
        specimen_lab_test => {
            class      => 'LIMS::DB::SpecimenLabTest',
            column_map => { id => 'specimen_id' },
            type       => 'one to many',
        },
        specimen_sample_type => {
            class      => 'LIMS::DB::SpecimenSampleType',
            column_map => { id => 'specimen_id' },
            type       => 'one to many',
        },
    ],
);
#=cut

#__PACKAGE__->meta->table('specimens');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2);

__PACKAGE__->meta->make_manager_class('specimens');

1;
