package LIMS::DB::Session;

use base qw(LIMS::RDBO);

# userid col pointless as it gets removed by ? CAP::Authen after session timeout
# when session is deleted & re-created (sans userid) - FIXED

__PACKAGE__->meta->setup (
    table   => 'sessions',

    columns => [
        id        => { type => 'serial', not_null => 1 },
        userid    => { type => 'varchar', length => 50 },
        a_session => { type => 'text', length => 65535, not_null => 1 },
        time      => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [ 'userid' ],
    
    relationships => [
        user => {
            class      => 'LIMS::DB::User',
            column_map => { userid => 'username' },
            type       => 'one to one',
        },        
    ],
);

__PACKAGE__->meta->make_manager_class('sessions');

1;
