#!/usr/bin/perl

# Perl Cookbook 19.9 Debugging the raw HTTP exchange
# dummyhttpd - start an HTTP daemon and print what the client sends

use strict;
use HTTP::Daemon;  # need LWP-5.32 or better

my $server = HTTP::Daemon->new(
    Timeout   => 60,
    LocalPort => 8081,
);

print "Please contact me at: <URL:", $server->url, ">\n";

BEGIN {
    # set flag for LIMS::cgiapp_prerun() to set tt_param app_url: 
    $ENV{HTTP_DAEMON_ON} = 1; # doesn't work - WTF??
}

while (my $client = $server->accept) {
  CONNECTION:
    while (my $answer = $client->get_request) {
        print $answer->as_string;
        $client->autoflush;
      RESPONSE:
        while (<STDIN>) {
            last RESPONSE   if $_ eq ".\n";
            last CONNECTION if $_ eq "..\n";
            print $client $_;
        }
        print "\nEOF\n";
    }
    print "CLOSE: ", $client->reason, "\n";
    $client->close;
    undef $client;
}