package LIMS::DB::ReferrerDepartment;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'referrer_department',

    columns => [
        id                       => { type => 'serial', not_null => 1 },
        referrer_id              => { type => 'integer', default => '0', not_null => 1 },
        parent_organisation_id   => { type => 'integer', default => '0', not_null => 1 },
        hospital_department_code => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'referrer_id', 'parent_organisation_id' ],

    foreign_keys => [
        hospital_department => {
            class       => 'LIMS::DB::HospitalDepartment',
            key_columns => { hospital_department_code => 'id' },
        },

        parent_organisation => {
            class       => 'LIMS::DB::ParentOrganisation',
            key_columns => { parent_organisation_id => 'id' },
        },

        referrer => {
            class       => 'LIMS::DB::Referrer',
            key_columns => { referrer_id => 'id' },
        },
    ],
    relationships => [
        requests => {
            class      => 'LIMS::DB::Request',
            column_map => { id => 'referrer_department_id' },
            type       => 'one to many',
        },
    ],
);

#__PACKAGE__->meta->table('clinician_organisation');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2);

__PACKAGE__->meta->make_manager_class('referrer_department');

1;
