package LIMS::Controller::Image;

use Moose;
BEGIN { extends 'LIMS::Base'; }
with (
	'LIMS::Controller::Roles::DataFile',
);
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

# ------------------------------------------------------------------------------
# default() should never be called direct - redirect to start page:
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->redirect( $self->query->url );
}

# ------------------------------------------------------------------------------
sub load : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
	
	# id param can be passed in as request.id or lab_number in format nn_nnnnn:
	my $token = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);

	my $request_data = $self->_get_request_data($token);
	
	my $contents = $self->load_image_files($request_data); # arrayref of filenames

	my %unrestricted = map { $_ => 1 } # anyone can view:
		grep { $_ =~/\.(jpg|pdf)\Z/i } @{ $contents->{files} };
		
    $self->tt_params(
		unrestricted => \%unrestricted,
		contents     => $contents,
		mini_dir     => $self->stash->{mini_dir}, # set in load_image_files()
		data 	     => $request_data,
	);

    return $self->tt_process('images/default.tt');
}

# ------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    # return $self->forbidden() unless $self->user_can(''); # TODO
    
    my $request_id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);
	
    $self->query->param('image_file') || return $self->forward('load');
 
	# check file doesn't already exist:	
	my $file = $self->check_image_file($request_id); # warn $file;
	
	if ( $file && ! $self->query->param('confirm_overwrite') ) {
		$self->tt_params( confirm_overwrite => 1 );
		return $self->forward('load');
	}

	my $rtn = $self->upload_image($request_id);
	
	return $rtn ? $self->error($rtn) : 
		$self->redirect( $self->query->url . '/image/=/' . $request_id );
}

# ------------------------------------------------------------------------------
sub delete : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
	
	# id param can be passed in as request.id or lab_number in format nn_nnnnn:
	my $token  = $self->param('id')
    || return $self->error('no id param passed to ' . $self->get_current_runmode);
	
	my $marked_file = $self->param('Id')
	|| return $self->error('no Id param passed to ' . $self->get_current_runmode);
	
	# need confirmation:
	unless ( $self->query->param('confirm_delete') ) {
		$self->tt_params( marked_file => $marked_file );
		$self->tt_params( confirm_delete => 1 );
		return $self->forward('load');
	}

	my $request_data = $self->_get_request_data($token);
	
	my %args = (
		request_data => $request_data,
		filename     => $marked_file,
	);
	
	$self->delete_image(\%args);
	
	$self->redirect( $self->query->url . '/image/=/' . $token );
}

# ------------------------------------------------------------------------------
# returns request data as hashref:
sub _get_request_data {
	my ($self, $id_param) = @_; $self->_debug_path();
	
	# id param can be passed in as request.id or lab_number in format nn_nnnnn:
	if ( $id_param =~ m!(\d{2})_(\d{1,})! ) {
		my %request = (
			request_number => int $2,
			year		   => 2000 + $1,
			id             => $id_param, # for template 'delete' url
		);
		return \%request;
	}
	else { 
		my $data = $self->model('Request')->get_request($id_param);
		return $data->as_tree; # downstream process expects hashref
	}
}

1;