package LIMS::DB::SpecimenSampleType;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'specimen_sample_type',

    columns => [
        specimen_id    => { type => 'integer', default => '0', not_null => 1 },
        sample_type_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'sample_type_id', 'specimen_id' ],

    foreign_keys => [
        sample_type => {
            class       => 'LIMS::DB::SampleType',
            key_columns => { sample_type_id => 'id' },
        },
        specimen => {
            class       => 'LIMS::DB::Specimen',
            key_columns => { specimen_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('specimen_sample_types');

1;