package LIMS::Local::Stuff;

use Silly::Werder;
use Data::Dumper;
use IO::All;

use strict;

sub silly_werder {
	my $min = shift || 1; # min number of sentences to generate
	my $max = shift || 5; # max number of sentences to generate
	
	my $werds = new Silly::Werder;

	# Generate a long random sentence calling as a class method
	$werds->set_werds_num(5,20);

	# Set the min and max number of werds per line
	$werds->set_werds_num(5, 9);      
  
	# Set the min and max # of syllables per werd
	$werds->set_syllables_num(1, 5);
  
	# End the sentences in a newline
	# $werds->end_with_newline(1); # default off
  
	# Set the language to mimic
	# $werds->set_language(qw/English small/);
	$werds->set_language('Shakespeare');

# $werds->sentence # ends in '.'
# $werds->question # ends in '?'
# $werds->exclamation # ends in '!'
# $werds->get_werd # get a single werd  
# $werds->line # random sentence, question, or exclamation
	
	return join ' ', map $werds->line, ($min .. 2 + int( rand($max) ) );
}
 
sub limerick {
	my $src = shift;
	
	# generate random number between 0 .. 211 (set 0 to 212):
    my $get_rand = sub { int rand(212) || 212 }; 
	my $rand = &$get_rand; # warn $rand;
    
    # unsuitable for 'public' view:
    unless ($ENV{DEVEL_SERVER}) {
        until ( grep $rand != $_, (77) ) { # Old Man of Jamaica
            $rand = &$get_rand;
        } # warn $rand;
    }
    
	my ($img, $width, $height, @lines, $found);
	
	ROW:
	for ( io($src)->slurp ) { # get all lines from src file
		next ROW unless $found += /\#$rand/; # $found becomes true on match eg #99
		last ROW if /<!-- end -->/; # exit loop here

		if ( /(\w+\d+)\;(\d+)\;(\d+)/ ) { # image info line
			($img, $width, $height) = ($1, $2, $3);
			next ROW;
		}
		next ROW if /#$rand/; # skip limerick id line
		push @lines, $_; # data line
	}
	
	return {
		img_src => $img,
		width   => $width,
		height  => $height,
		lines   => \@lines,
	}
}

1;

