package LIMS::DB::LabSection;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_sections',

    columns => [
        id                 => { type => 'serial', not_null => 1 },
        section_name       => { type => 'varchar', length => 255, not_null => 1 },
        has_result_summary => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
        has_section_notes  => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
        has_test_sign_out  => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
        has_results_import => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
        has_foreign_id     => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
        has_labels         => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
        is_active          => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'section_name' ],

    relationships => [
        lab_section_status_option => {
            class      => 'LIMS::DB::LabSectionStatusOption',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
        lab_tests => {
            class      => 'LIMS::DB::LabTest',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
        lab_section_sample_type => {
            class      => 'LIMS::DB::LabSectionSampleType',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
        request_lab_section_foreign_id => {
            class      => 'LIMS::DB::RequestLabSectionForeignID',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
        request_lab_section_notes => {
            class      => 'LIMS::DB::RequestLabSectionNote',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
        request_results_summary => {
            class      => 'LIMS::DB::RequestResultSummary',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
        result_summary_options => {
            class      => 'LIMS::DB::ResultSummaryOption',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
        screen_lab_test_detail => {
            class      => 'LIMS::DB::ScreenLabTestDetail',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
        
    ],
);

__PACKAGE__->meta->make_manager_class('lab_sections');

1;