package LIMS::Controller::Admin::Lab::Test::Linked;

use base 'LIMS::Base';
use LIMS::Local::Sugar;
use Data::Dumper;

use Moose;
with 'LIMS::Controller::Roles::DataMap';
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode);    
    
    my $vars = $self->query->Vars; # warn Dumper $vars;
    $self->tt_params( vars => $vars );

    { # get current linked lab-tests:
        my @joins = (
			'parent_lab_test.lab_section',
			'linked_lab_test.lab_section',
		);
		my $args = { sort_by => 'parent_lab_test.field_label' };
        my @args = ( 'LinkedLabTest', $args, \@joins );
        my $linked_tests = $self->model('Base')->get_objects(@args);
        $self->tt_params( all_linked_tests => $linked_tests );
        
        # hashmap to highlight existing entries:
        my %map = map +($_->parent_test_id => 1), @$linked_tests;
        $self->tt_params( linked_tests_map => \%map );
    }
    { # get lab sections:
        my $sections = $self->model('LabSection')->get_lab_sections();
        $self->tt_params( sections => $sections );
    }
    # get lab tests for selected section:
    if ( my $lab_section_id = $vars->{lab_section_id} ) {
        my %args = ( lab_section_id => $lab_section_id );
        my $lab_tests = $self->model('LabTest')->get_section_lab_tests(\%args);
        # cache in case linked lab section is same as parent section:
        $self->stash( parent_lab_tests => $lab_tests );
        $self->tt_params( parent_tests => $lab_tests );
    }
    if ( my $linked_lab_section_id = $vars->{linked_lab_section_id} ) {
        my $linked_lab_section_tests; # get tests for section if different:
        if ( $linked_lab_section_id == $vars->{lab_section_id} ) { # same section
            $linked_lab_section_tests = $self->stash->{parent_lab_tests};
        }
        else { # get tests for different section
            my %args = ( lab_section_id => $linked_lab_section_id );
            $linked_lab_section_tests
                = $self->model('LabTest')->get_section_lab_tests(\%args);
        }
        $self->tt_params( linked_lab_section_tests => $linked_lab_section_tests );
    }
    
   	return $self->tt_process;
}

runmode do_link {
    $self->_debug_path($self->get_current_runmode);    

    my $parent_lab_test_id = $self->param('id')
        || return $self->error('no id passed to ' . $self->get_current_runmode);
    my @linked_lab_test_id = $self->query->param('linked_test_id'); # can be list or empty
    
    my %data = (
        parent_test_id => $parent_lab_test_id,
        linked_test_id => \@linked_lab_test_id,
    ); # warn Dumper \%data;
    
    my $rtn = $self->model('LabTest')->update_linked_lab_tests(\%data);

	if ($rtn) {
		return $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{create_success} );
		return $self->redirect( $self->query->url . '/admin/lab_test_linked' ); # safer to redirect after db edit
	}    
}

1;