package LIMS::DB::PanelLabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'panel_lab_test',

    columns => [
        panel_test_id => { type => 'integer', not_null => 1 },
        lab_test_id   => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'panel_test_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        panel_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { panel_test_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('panel_lab_tests');

1;
