package LIMS::DB::Outreach::NonParticipantPractice;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'non_participant_practice',

    columns => [
        practice_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'practice_id' ],

    foreign_keys => [
        practice => {
            class       => 'LIMS::DB::ReferralSource',
            key_columns => { practice_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('non_participant_practices');

1;