package LIMS::Model::Storage;

use Moose;
extends 'LIMS::Model::Base';
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable;

use Data::Dumper;

#-------------------------------------------------------------------------------
sub input_storage {
    my ($self, $params) = @_;
    
    # get specimen code => id map:
    my $o = LIMS::DB::Specimen::Manager->get_specimens();
    my %map = map { $_->sample_code => $_->id } @$o;
    
    # transfer required $params to %data
    my %data = map { $_ => $params->{$_} } qw(request_id vialId);
    # add specimen.id:
    my $specimen = $params->{specimen};
    $data{specimen_id} = $map{$specimen}; # warn Dumper \%data;
    
    my $rtn = do {
        my %args = ( class => 'RequestStorage', data => \%data );
        $self->update_object(\%args);
    };
    return $rtn; 
}

#-------------------------------------------------------------------------------
sub get_request_storage {
    my ($self, $request_id) = @_;
    
    my @args = (
        query => [ request_id => $request_id ],
        with_objects => 'specimen',
    );
    my $o = LIMS::DB::RequestStorage::Manager->get_objects(@args);
    return $o;
}

#-------------------------------------------------------------------------------
sub get_storage_rack {
    my ($self, $plateId) = @_;
    
    my $o = LIMS::DB::StorageRack->new( plateId => $plateId )->load_speculative;
    return $o ? $o->as_tree : 0; # return hashref for use in session
}

#-------------------------------------------------------------------------------
sub get_rack_contents { # find rack contents by rack.id, or list of vialId's:
    my ($self, $args) = @_;
    
    my $query;
    if ( my $rack_id = $args->{rack_id} ) {
        $query = [ rack_id => $rack_id ];
    }
    elsif ( my $vial_ids = $args->{vial_ids} ) {
        $query = [ vialId => $vial_ids ];
    }
    my @args = ( query => $query );
    my $o = LIMS::DB::RequestStorage::Manager->get_objects(@args);
    return $o;
}

1;