package Anonymise::HILIS3;

use Moose;
extends 'AnonymisePatient';

use Data::Random qw(:all);

has path_to_app => ( is  => 'ro', isa => 'Str', required => 1 );

# replaces some $vals entries - doesn't return anything:
sub anonymise_patient {
	my $self = shift;
	my $vals = shift;

    my $substitute = $self->get_substitutes;

    my @last_names  = @{ $substitute->{last_names  } };
    my @first_names = @{ $substitute->{first_names } };
    my @boys_names  = @{ $substitute->{male_names  } };
    my @girls_names = @{ $substitute->{female_names} };

	my $first_name = '';
	my $gender = $vals->{Sex} || '';

	if ($gender eq 'M') {
		$first_name = $boys_names[rand @boys_names];
	}
	elsif ($gender eq 'F') {
		$first_name = $girls_names[rand @girls_names];
	}
	else {
		$first_name = $first_names[rand @first_names];
	}

	# replace these $vals entries:
	$vals->{LName} = uc $last_names[rand @last_names];
	$vals->{FName} = ucfirst $first_name;
    if ( $vals->{DoB} ) { # Data::Random::rand_date
        $vals->{DoB} = rand_date(min => '1920-1-1', max => '2000-1-1');
    }
    if ( $vals->{NHSNo} ) {
        # needs to be unique
        $vals->{NHSNo} = $self->make_nhsno;
    }
    if ( $vals->{PatNo} ) {
        my @digits = (0 .. 9);
        $vals->{PatNo} =~ s/\d/$digits[rand @digits]/eg;
    }
}

1;
