package LIMS::DB::ScreenCategory;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'screen_category',

    columns => [
        id        => { type => 'serial', not_null => 1 },
        name      => { type => 'varchar', length => 50 },
        is_active => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'name' ],

    relationships => [
        screen => {
            class      => 'LIMS::DB::Screen',
            column_map => { id => 'category_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('screen_categories');

1;
