package LIMS::Controller::Admin::Config::DiagnosisContextWarnings;

use Moose;
BEGIN { extends 'LIMS::Base'; }
with 'LIMS::Controller::Roles::DataMap';
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use LIMS::Local::Sugar;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
startmode default ($errs) { # $self->stash( errs => $errs );
    $self->_debug_path($self->get_current_runmode);

	{ # list of all context_warnings:
		my $context_warnings = $self->model('Diagnosis')
			->get_all_context_warnings({ sort_by => 'description'});
		$self->tt_params( context_warning_opts => $context_warnings );
	}
	{ # diagnosis_context_warnings:
		my $o = $self->model('Diagnosis')->get_diagnosis_context_warnings;
		my %map = map { $_->diagnosis->name => $_->as_tree } @$o;
		$self->tt_params( diagnosis_context_warnings => \%map );
	}
	{ # diagnoses:
		my $diagnoses_map = $self->diagnoses_map('name'); # send key
		$self->tt_params( diagnoses => $diagnoses_map );
	}
    
	# get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('diagnosis_context');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit_context_warning ($id) {
    $self->_debug_path($self->get_current_runmode); # $self->stash( errs => $errs );

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('Diagnosis')->get_context_warning($id);

    $self->tt_params( data => $data );

    return $self->tt_process;
}

# -------------------------------------------------------------------------------------
runmode update_context_warning ($id) { 
    $self->_debug_path($self->get_current_runmode); # $self->stash( errs => $errs );

	my $err_rtn = $id ? 'edit_context_warning' : 'default';

	my $dfv = $self->check_rm($err_rtn, $self->validate('context_warnings') )
	|| return $self->dfv_error_page;
	
    my $data = $dfv->valid; # $self->debug($data);	

	# put id (if submitted) into data for model():	
    if ( $id ) { $data->{id} = $id } # $self->debug($data);

    my $rtn = $self->model('Diagnosis')->update_context_warning($data); 

    if ($rtn) {
        return $self->error($rtn);
	}
	else {
		# set flash success message:
		$self->flash( info => $self->messages('action')->{edit_success} );
        $self->redirect( $self->query->url . '/config/diagnosis-context-warnings' );
	}
}

# -------------------------------------------------------------------------------------
runmode edit_diagnosis_context_warning ($errs, $id) {
    $self->_debug_path($self->get_current_runmode); # $self->stash( errs => $errs );

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('Diagnosis')->get_diagnosis_context_warning($id);

	{ # list of all context_warnings:
		my $context_warnings
			= $self->model('Diagnosis')->get_all_context_warnings;
		$self->tt_params( context_warnings => $context_warnings );
	}

    $self->tt_params( data => $data );

    # don't need js validation - only 1 param and no blank in its select menu

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode update_diagnosis_context_warning ($id) {
    $self->_debug_path($self->get_current_runmode); # $self->stash( errs => $errs );

	# forward if it's a deletion request:
	return $self->forward('delete_diagnosis_context_warning')
		if $self->query->param('.delete');
	
	my $error_return = $id ? 'edit_diagnosis_context_warning' : 'default';
	my $dfv = $self->check_rm($error_return, $self->validate('diagnosis_context') )
	|| return $self->dfv_error_page;
	
    my $data = $dfv->valid; # $self->debug($data);	
	
	# put id (if submitted) into data for model():	
    if ( $id ) { $data->{id} = $id }

    my $rtn = $self->model('Diagnosis')->update_diagnosis_context_warning($data); 

    return $rtn
        ? $self->error($rtn)
        : $self->redirect( $self->query->url . '/config/diagnosis-context-warnings' );
}

# -------------------------------------------------------------------------------------
runmode delete_diagnosis_context_warning ($id) {
    $self->_debug_path($self->get_current_runmode); # $self->stash( errs => $errs );
	
    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

	# need confirmation:
	unless ( $self->query->param('confirm_delete') ) {
		my $data = $self->model('Diagnosis')->get_diagnosis_context_warning($id);
		$self->tt_params( data => $data );
		return $self->tt_process({ context_warning_id => $id });
	}

	my $rtn = $self->model('Diagnosis')->delete_diagnosis_context_warning($id);
	
	return $rtn
		? $self->error($rtn)
		: $self->redirect( $self->query->url . '/config/diagnosis-context-warnings' );
}

1;