package LIMS::Model::RequestOption;

use base 'LIMS::Model::Base';

use strict;

# -------------------------------------------------------------------------------------
sub get_request_options {
    my $self = shift;
    
    my $request_opts = LIMS::DB::AdditionalOption::Manager
        ->get_additional_options( sort_by => 'option_name' );
    
    return $request_opts;
}

# -------------------------------------------------------------------------------------
sub get_request_option {
    my ($self, $request_id) = @_;
    
    my $request_opt = LIMS::DB::AdditionalOption->new( id => $request_id )->load;
    
    return $request_opt;
}

# ------------------------------------------------------------------------------
sub update_request_options {
    my $self = shift;
    my $data = shift;  $self->debug( $data );

    my %args = ( class => 'AdditionalOption', data => $data );
    
    return $self->update_object(\%args);    
}

1;