package LIMS::DB::RequestGrossDescription;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_gross_description',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        detail     => { type => 'text', length => 65535, not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_gross_description');

1;
