#!/usr/bin/perl

# test AJAX functions using url - cannot test javascript functions without
# don't need login for ajax functions

use Test::WWW::Mechanize::CGIApp;

use strict;
use warnings;

use Test::More tests => 88; # use Test::More 'no_plan';

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# need to login otherwise validation routines that use LIMS::Model::Roles::AuthUser
# die if no user_profile:
do_login();

# lab_tests table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&field_label=AML'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate field_label detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&field_label=NEW'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique field_label not flagged",
);

# lab_sections table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&section_name=Histology'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate section_name detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&section_name=FISH'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique section_name not flagged",
);

# screens table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&screen_description=AML'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate screen description detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&screen_description=APML'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique screen description not flagged",
);

# user_functions table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&function_name=register'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate function_name detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&function_name=authorise'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique function_name not flagged",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&function_detail=register requests'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate function_detail detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&function_detail=authorisation description'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique function_name not flagged",
);

# user_groups table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_name=su'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate group_name detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_name=mla'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique group_name not flagged",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_label=SuperUser'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate group_label detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_label=MLA'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique group_label not flagged",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_detail=SuperUser description'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate group_detail detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&group_detail=MLA description'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique group_detail not flagged",
);

# user_locations table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&location_name=HMDS'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate location_name detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&location_name=York'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique location_name not flagged",
);

# users table:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&username=admin'); # warn $mech->content;

$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate username detected",
);

$mech->get_ok('/ajax?fname=do_ajax&args=foo&username=guest'); # warn $mech->content;

$mech->content_lacks(
    dfv_format('not_unique'),
    "ajax function: unique username not flagged",
);

# requests:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_request_no=1'); # warn $mech->content;

{
    $mech->content_is(
        dfv_format('not_unique'),
        'ajax function: duplicate lab_number detected',
    );
}

$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_request_no=3'); # warn $mech->content;

$mech->content_is(
    'OK',
    "ajax function: unique lab_number not flagged",
);

# specimens:
my @valid_specimens = (
    'pb',
    'pb,lu',
    'pb, lu',
    'pb, lu bmat',
    'pb lu, bmat',
    'pb,lu,bma',
    'pb  lu bmat',
);

my @invalid_specimens = (
    'bm',
    'pb,bm',
);

foreach (@valid_specimens) {
    $mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_specimen='.$_); # warn $mech->content;

    $mech->content_is(
        'OK',
        'ajax function: valid specimen code',
    );
}

{
    foreach (@invalid_specimens) {
        $mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_specimen='.$_); # warn $mech->content;

        $mech->content_is(
            dfv_format('invalid_entry'),
            'ajax function: invalid specimen code',
        );
    }
}

# invalid nhs_number:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_nhsno=1234567890');
$mech->content_is(
    dfv_format('invalid_entry'),
    'ajax function: invalid nhs number',
);

# valid nhs_number:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&is_valid_nhsno=0123456789');
$mech->content_is(
    'OK',
    'ajax function: valid nhs number',
);

# find referrers:
# /ajax/get_referrers?source_id=39;referrer_name=foo

# clinicians:
$mech->get_ok('/ajax/get_clinicians?source_id=1;referrer_name=cut');
$mech->content_contains(
    qq!<rs id="C7654321" info="General Surgery">Cutter, S</rs>!,
    'ajax function: expected clinician retrieved',
);

# error_code:
$mech->get_ok('/ajax?fname=do_ajax&args=A&error_code=A'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate error_code detected",
);

# referral_source:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&organisation_code=B12345'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate organisation_code detected",
);
$mech->get_ok('/ajax?fname=do_ajax&args=foo&ref_source_name=Newtown General Infirmary'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate referral_source detected",
);


# parent_organisation:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&parent_code=B12345'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate parent_code detected",
);
$mech->get_ok('/ajax?fname=do_ajax&args=foo&parent_description=NEWTOWN NHS TRUST'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate parent_organisation description detected",
);

# audit_option:
$mech->get_ok('/ajax?fname=do_ajax&args=foo&audit_options=Anaemia'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate audit_option detected",
);

# diagnosis
$mech->get_ok('/ajax?fname=do_ajax&args=foo&new_diagnosis=RAEB'); # warn $mech->content;
$mech->content_is(
    dfv_format('not_unique'),
    "ajax function: duplicate diagnosis detected",
);

# email_address:
$mech->get_ok('/ajax/get_email_addresses?address=us'); # warn $mech->content;
$mech->content_contains(
    qq!<rs id="user\@anywhere.net" info="">user\@anywhere.net</rs>!,
    "ajax function: expected email address retrieved"
);
