package LIMS::DB::UserLocation;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'user_locations',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        location_name => { type => 'varchar', length => 50 },
        active	      => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

# region_code   => { type => 'varchar', length => 3 },
# email_contact => { type => 'varchar', length => 50 },

    primary_key_columns => [ 'id' ],

    unique_key => [ 'location_name' ],

    relationships => [
        users => {
            class      => 'LIMS::DB::User',
            column_map => { id => 'user_location_id' },
            type       => 'one to many',
        },
    ],
);

# or to see what it should be:
#__PACKAGE__->meta->table('trials');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2, braces => 'bsd');

__PACKAGE__->meta->make_manager_class('user_locations');

1;
