package LIMS::Controller::Roles::User;

use Moose::Role;
use MooseX::AttributeHelpers;

has lab_staff => (
    is => 'ro',
    isa => 'ArrayRef[HashRef]',
    default => sub { [] },
	metaclass => 'Collection::Array',
	provides  => {
        push  => 'add_to_lab_staff',
    },
);

sub get_lab_staff_users {
    my $self = shift;

	my $users = $self->model('User')->get_all_users({sort_by => 'username'});

    my $lab_name
        = $self->cfg('settings')->{lab_name_abbreviation}; #  warn $lab_name;
    
    my @lab_staff;
    
    while ( my $user = $users->next ) {
        next unless $user->active eq 'yes'
            && $user->user_location->location_name eq $lab_name;
        
        my %user = (
            id => $user->id,
            username => $user->username,
        );
        
        # $self->add_to_lab_staff(\%user); # Can't use an undefined value as an
        # ARRAY reference at /home/raj/perl5/lib/perl5/MooseX/AttributeHelpers/MethodProvider/Array.pm line 20. 
        push @lab_staff, \%user;
    } # $self->debug(\@lab_staff);
    
    return \@lab_staff;
}

1;
