package LIMS::Local::PDF;

use Moose;
has path => ( is => 'ro', isa => 'Str', required => 1);
has htmldoc => ( is => 'ro', isa => 'HTML::HTMLDoc', lazy_build => 1 );
__PACKAGE__->meta->make_immutable;

use HTML::HTMLDoc;
use Data::Dumper;

sub make_pdf {
    my $self = shift;
    my $args = shift; # warn Dumper $args->{session}->id;
    
    my $htmldoc = $self->htmldoc;
    
    { # logo:
        my $logo = $self->path . '/images/logo.jpeg';
        $htmldoc->set_logoimage($logo);
        $htmldoc->set_header('.', '.', 'l'); # positions; '.' = null; 'l' = logo
    }
    { # format:
        $htmldoc->set_bodyfont('Times');
        $htmldoc->set_fontsize(10);
        $htmldoc->set_top_margin(10, 'mm');
        $htmldoc->set_left_margin(15, 'mm');
        $htmldoc->set_right_margin(15, 'mm');
        $htmldoc->set_bottom_margin(10, 'mm');
        
        # naughty, but setting not otherwise available:
        $self->_set_htmldoc_param('headfootsize', 9);
        # $htmldoc->set_footer('t', 'd', '1'); # doesn't work
    }

    if ( my $html = $args->{html} ) {
        # set session ID in case img called in tmpl:
        my $session_id = 'CGISESSID=' . $args->{session}->id;
        $self->_set_htmldoc_param(cookies => $session_id); # not passed by browser
        
        $htmldoc->set_html_content($html); # or $htmldoc->set_input_file($filename);
    }
    elsif ( my $filename = $args->{file} ) { # warn $filename;
        $htmldoc->set_input_file('/tmp/'.$filename);
        #my $pdf = `/home/raj/www/perl-lib/wkhtmltopdf/wkhtmltopdf /tmp/$filename -`;
        #return $pdf;
    }    
   
    my $pdf = $htmldoc->generate_pdf(); # my @errs =  $htmldoc->error(); warn @errs if @errs;

    return $pdf->to_string(); # $pdf->to_file('foo.pdf'); 
}

sub _build_htmldoc {
    my $self = shift;
    
    my $htmldoc = new HTML::HTMLDoc(mode => 'file', tmpdir =>'/tmp');
    return $htmldoc;
}

# need to use undocumented 'private' _set_doc_config method for unsupported params:
sub _set_htmldoc_param {
    my $self = shift;    
    
    $self->htmldoc->_set_doc_config(@_); # pass args straight in
}

1;

