package LIMS::DB::ReferralType;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'referral_types',

    columns => [
        id              => { type => 'serial', not_null => 1 },
        description     => { type => 'varchar', length => 255, not_null => 1 },
        prefix          => { type => 'varchar', length => 2 },
        default_unknown => { type => 'varchar', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        parent_organisations => {
            class      => 'LIMS::DB::ParentOrganisation',
            column_map => { id => 'referral_type_id' },
            type       => 'one to many',
        },
        referral_sources => {
            class      => 'LIMS::DB::ReferralSource',
            column_map => { id => 'referral_type_id' },
            type       => 'one to many',
        },
        referrers => {
            class      => 'LIMS::DB::Referrer',
            column_map => { id => 'referral_type_id' },
            type       => 'one to many',
        },
        # add relationship for Model::Request::_build_referral_type_map()
        unknown_parent_org => {
            class      => 'LIMS::DB::ParentOrganisation',
            column_map => { default_unknown => 'parent_code' },
            type       => 'one to one',
            optional   => 1,
        },
        unknown_referrers => { # using locations instead of referrers now
            class      => 'LIMS::DB::Referrer',
            column_map => { default_unknown => 'national_code' },
            type       => 'one to one',
            optional   => 1,
        },
    ],
);

#=cut
=begin
__PACKAGE__->meta->table('referral_types');
__PACKAGE__->meta->auto_initialize;
 print __PACKAGE__->meta->perl_class_definition(indent => 4);
=cut

__PACKAGE__->meta->make_manager_class('referral_types');

1;