package LIMS::Controller::Resources;

use Moose;
BEGIN { extends 'LIMS::Base'; }
with (
    'LIMS::Controller::Roles::DataMap',
    'LIMS::Controller::Roles::DataFile',
    'LIMS::Controller::Roles::Resource',

);
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

use Data::Dumper;

#-------------------------------------------------------------------------------
sub menu : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub list_all_screen_tests : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $all_assigned_tests = $self->model('Screen')->get_all_assigned_tests;

    my %tests;

    while (my $test = $all_assigned_tests->next) { # $self->debug($test);
        my $description = $test->screen->description;
        my $field_label = $test->lab_test->field_label;

        push @{ $tests{$description} }, $field_label;
    }

    $self->tt_params(
        tests => \%tests,
    );

    return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub data_file : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;
  
    return $self->forbidden() unless $self->user_can('do_admin');
    return $self->tt_process('resources/new_data_file.tt', { error => $errs });
}

#-------------------------------------------------------------------------------
sub active_sessions : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    
    my $args = { sort_by => 'time desc' };
    my $sessions = $self->model('Base')->get_objects('Session', $args);
    
    $self->tt_params( sessions => $sessions );
    return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub get_data_file : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('do_admin');
    
    my $method = $self->query->param('method'); # warn $method;
    
    if ($method eq 'url') {
        return $self->data_file_from_url; # Role::DataFile
    }
    elsif ($method eq 'upload') {
        return $self->data_file_from_upload; # Role::DataFile
    }
    else {
        return $self->forward('data_file');
    }       
}

#-------------------------------------------------------------------------------
sub user_messages : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    
    if ( my $recipient_id = $self->param('id') ) { # if passed from 'hello' page
        my $user = $self->model('User')->get_user_profile($recipient_id);
        $self->tt_params( recipient => $user );
    }
    else {
        my $profile  = $self->authen->store->fetch('yooza_profile');
        
        { # get any user-to-user messages:
            my $messages = $self->get_user_messages($profile->{id});
            $self->tt_params( user_messages => $messages );
        }
        { # get any admin-to-user messages: 
        	my $user_location = $profile->{user_location}->{location_name};
            my $messages = $self->get_admin_messages($user_location);
            $self->tt_params( admin_messages => $messages );
        }

        { # get list of users:
            my @sort_order = qw(user_location.location_name last_name first_name);
            my $args = { sort_by => \@sort_order }; # override default
            my $users = $self->model('User')->get_all_users($args);
            $self->tt_params( users => $users );
        }
    }
    return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub new_message : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    
    my $vars = $self->query->Vars();
    return $self->forward('user_messages')
        if grep { ! $vars->{$_}} qw(user_id message); # dfv overkill for 2 vars ??    
    
    my $rtn = $self->model('User')->new_user_message($vars);
    
    if ($rtn) {
        return $self->error($rtn);
    }
    else {
        $self->flash( info => $self->messages('user')->{msg_sent});
        return $self->redirect( $self->query->url . '/resources/user_messages' );
    }
}

#-------------------------------------------------------------------------------
sub new_diagnoses : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $org_code = $self->query->param('org_code'); # optional
    
    my $data = $self->new_and_relapsed_diagnoses($org_code);
    
    $self->tt_params(
        locations => $data->{locations_map},
        results   => $data->{results},
    );
    
    return $self->tt_process();
}

1;
