package LIMS::Controller::History;

use Moose;
BEGIN { extends 'LIMS::Base'; }
with (
    'LIMS::Controller::Roles::Diff',
    'LIMS::Controller::Roles::DataMap',
    'LIMS::Controller::Roles::History', # get_*_history()
);
__PACKAGE__->meta->make_immutable(inline_constructor => 0);

# ------------------------------------------------------------------------------
# default() should never be called direct - redirect to start page:
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->redirect( $self->query->url );
}

# ------------------------------------------------------------------------------
sub load : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    return $self->forbidden() unless $self->user_can('view_history');
    
    my $request_id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);

    # load history data into tt_params:
    $self->_load_history_data($request_id);

    return $self->tt_process('history/default.tt');
}

# ------------------------------------------------------------------------------
sub previous_diagnosis : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $request_id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);

    my $previous_diagnoses
        = $self->model('History')->get_diagnosis_history($request_id);
        
    my $request_data
        = $self->model('Request')->get_patient_and_request_data($request_id);
    
    $self->tt_params(
        request_data       => $request_data,
        previous_diagnoses => $previous_diagnoses,
    );
    
    return $self->tt_process;  
}

# ------------------------------------------------------------------------------
sub comment : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $request_id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);
    
    my $comment_history = $self->diff_comment_history($request_id);
    $self->tt_params( history => $comment_history );
    
    my $request = $self->model('Request')->get_request($request_id);
    $self->tt_params( data => $request );
    
    return $self->tt_process;
}

# ------------------------------------------------------------------------------
sub request_view : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $request_id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);
    
    my $history = $self->model('History')->get_view_history($request_id);
    $self->tt_params( history => $history );
    
    return $self->tt_process;    
}

# ------------------------------------------------------------------------------
sub request_print : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $request_id = $self->param('id')
    || return $self->error('no id passed to ' . $self->get_current_runmode);
    
    my $history = $self->model('History')->get_print_history($request_id);
    $self->tt_params( history => $history );
    
    return $self->tt_process;    
}

# ------------------------------------------------------------------------------
sub _load_history_data {
    my ($self, $request_id) = @_; $self->_debug_path();

    my $patient_id = $self->model('PatientCase')
        ->get_patient_case_by_request_id($request_id)
        ->patient_case->patient_id; # $self->debug($patient_id);

    my %history_data = (
        patient_data   => $self->get_patient_history($patient_id),
        request_data   => $self->get_request_history($request_id),
        lab_test_data  => $self->get_lab_test_history($request_id),
        diagnosis_data => $self->get_diagnosis_history($request_id),
    );

    if ($history_data{patient_data}) { # need error_codes:
        $history_data{error_codes} = $self->error_codes_map;
    }
    
    $self->tt_params( history => \%history_data );
}

1;
