package LIMS::DB::PatientDemographic;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table   => 'patient_demographics',

    columns => [
        patient_id      => { type => 'integer', default => '0', not_null => 1 },
        address         => { type => 'varchar', length => 255 },
        post_code       => { type => 'varchar', length => 8 },
        contact_number  => { type => 'varchar', length => 15 },
        gp_id           => { type => 'integer', default => '0' },
        practice_id     => { type => 'integer', default => '0' },
        status          => { type => 'enum', check_in => [ 'alive', 'dead' ], default => 'alive' },
        dod             => { type => 'date' },
        time            => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::DB::Patient',
            key_columns => { patient_id => 'id' },
        },
        
        referrer => {
            class       => 'LIMS::DB::Referrer',
            key_columns => { gp_id => 'id' },
        },
        
        practice => {
            class       => 'LIMS::DB::ReferralSource',
            key_columns => { practice_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('patient_demographics');

1;