#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;

use strict;
use warnings;

use DateTime;
use POSIX;

use Test::More tests => 20; # use Test::More 'no_plan';

=begin # tests:
1) submit new (valid) test - missing description
2) submit new (valid) test
3) retrieve new test & set inactive
4) submit new test with duplicate sample_code
5) submit new test with invalid sample_code
6) submit new test with valid sample_code
7) retrieve new test and edit 'description' value
=cut

BEGIN {
    require 't/test-lib.pl';

    use DateTime;
    DateTime->DefaultLocale('en_GB');
}

my $mech = get_mech();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

do_login();

$mech->get_ok('/config/specimens');                           # print_and_exit();

$mech->content_contains(
    'Admin &raquo; Specimens',
    'OK: config specimens page loaded',
);

# submit new specimen - missing description:
{
    $mech->submit_form(
        fields => {
            sample_code => 'LA', # not already in test_data.sql
        }
    );                                                        # print_and_exit();
    
    has_missing();
    
    $mech->submit_form(
        fields => {
            sample_code => 'LA',
            description => 'lymph node aspirate',
        }
    );                                                        # print_and_exit();
    
    has_missing();

    $mech->submit_form(
        fields => {
            sample_code => 'LA',
            description => 'lymph node aspirate',
            sample_type_id => 1,
        }
    );                                                        # print_and_exit();

    $mech->content_contains(
        q!name="sample_code" value="LA"!,
        'OK: sample_code present in form',
    );
    
    $mech->content_contains(
        q!name="description" value="lymph node aspirate"!,
        'OK: description present in form',
    );
    
    $mech->content_contains(
        q!option value="yes" selected!,
        'OK: specimen status default( active)',
    );                                                        # print_and_exit();
}

# inactivate specimen:
{
    $mech->follow_link( text => 'Edit', n => 1 );             # print_and_exit();

    $mech->field('active', 'no');
    $mech->submit();                                          # print_and_exit();
    
    $mech->content_contains(
        q!option value="no" selected!,
        'OK: specimen status changed to inactivate',
    );                                                        # print_and_exit();
}

# try duplicate code in new record:
{
    $mech->get_ok('/config/specimens');                       # print_and_exit();

    $mech->submit_form(
        fields => {
            sample_code => 'BMA',
            description => 'bone marrow aspirate',
        },
    );                                                        # print_and_exit();
    
    ### check duplicate found:
    has_duplicate();
}

# try invalid sample_code
$mech->submit_form(
    fields => {
        sample_code => 'LF/U',
    }
);                                                            # print_and_exit();

has_dfv_errors();

$mech->content_contains(
    dfv_format('single_word'),
    'OK: single word required',
);                                                            # print_and_exit();

# correct sample_code but incorrect description:
$mech->submit_form(
    fields => {
        sample_code => 'LFU', # not already in test_data.sql
        description => 'lymph node biopsy, fixed', # <= wrong description
        sample_type_id => [1, 2],
    }
);                                                         #  print_and_exit();

$mech->content_contains(
    q!name="sample_code" value="LFU"!,
    'OK: sample_code present in form',
);

$mech->content_contains(
    q!name="description" value="lymph node biopsy, fixed"!,
    'OK: description present in form',
);                                                            # print_and_exit();

# edit mis-spelled description:
$mech->follow_link( text => 'Edit', n => 4 );                 # print_and_exit();

$mech->submit_form(
    fields => {
        description => 'lymph node biopsy, fixed & unfixed',
    }
);                                                            # print_and_exit();

$mech->content_lacks(
    q!name="description" value="lymph node biopsy, fixed"!,
    'OK: old specimen description not present in form',
);

$mech->content_contains(
    q!name="description" value="lymph node biopsy, fixed &amp; unfixed"!,
    'OK: new specimen description present in form',
);                                                            # print_and_exit();

# do_logout(); logout link not available for admin function
