#! /bin/sh

USERNAME=www-data
FCGI_SOCKET=/var/run/hilis4/$CENTRE.socket
DESC="lims_fastcgi server"
DAEMON=lims_external.fcgi
NAME=lims_fastcgi
PIDFILE=/var/run/hilis4/$CENTRE.pid
SCRIPT_DIR=/home/raj/apps/HILIS4/trunk/script
SCRIPTNAME=/etc/init.d/$NAME
# pass any args to fastcgi script:
ARGS=

# Exit if the package is not installed - should produce error msg
[ -x "$SCRIPT_DIR/$DAEMON" ] || exit 0

#
# Function that starts the daemon/service
#
do_start() {
    # Return
    #   0 if daemon has been started
    #   1 if daemon was already running
    #   2 if daemon could not be started
    start-stop-daemon --chuid $USERNAME --start --pidfile $PIDFILE \
        --exec $SCRIPT_DIR/$DAEMON --test -- -f $ARGS > /dev/null \
        || return 1
    start-stop-daemon --chuid $USERNAME --start --pidfile $PIDFILE \
        --exec $SCRIPT_DIR/$DAEMON -- -f $ARGS \
        || return 2
}

#
# Function that stops the daemon/service
#
do_stop() {
    # Return
    #   0 if daemon has been stopped
    #   1 if daemon was already stopped
    #   2 if daemon could not be stopped
    #   other if a failure occurred
    start-stop-daemon --stop --quiet --retry=TERM/10/KILL/5 --pidfile \
        $PIDFILE --name $NAME
    RETVAL="$?"
    [ "$RETVAL" = 2 ] && return 2

    # Wait for children to finish too if this is a daemon that forks
    # and if the daemon is only ever run from this initscript.
    # If the above conditions are not satisfied then add some other code
    # that waits for the process to drop all resources that could be
    # needed by services started subsequently.  A last resort is to
    # sleep for some time.

    start-stop-daemon --stop --quiet --oknodo --retry=0/30/KILL/5 --exec \
        $SCRIPT_DIR/$DAEMON
    [ "$?" = 2 ] && return 2

    # Many daemons don't delete their pidfiles when they exit.
    rm -f $PIDFILE
    rm -f $FCGI_SOCKET

    return "$RETVAL"
}

case "$1" in
    start)
        echo "Starting $DESC" "$NAME..."
        do_start
        case "$?" in
                0|1) echo "   Starting $DESC $NAME succeeded" ;;
                *)   echo "   Starting $DESC $NAME failed" ;;
        esac
        ;;
    stop)
        echo "Stopping $DESC $NAME..."
        do_stop
        case "$?" in
                0|1) echo "   Stopping $DESC $NAME succeeded" ;;
                *)   echo "   Stopping $DESC $NAME failed" ;;
        esac
        ;;
    restart|force-reload)
        #
        # If the "reload" option is implemented then remove the
        # 'force-reload' alias
        #
        echo "Restarting $DESC $NAME..."
        do_stop
        case "$?" in
          0|1)
                do_start
                case "$?" in
                    0|1) echo "   Restarting $DESC $NAME succeeded" ;;
                    *)   echo "   Restarting $DESC $NAME failed: couldn't start $NAME" ;;
                esac
                ;;
          *)
                echo "   Restarting $DESC $NAME failed: couldn't stop $NAME" ;;
        esac
        ;;
    *)
        echo "Usage: $SCRIPTNAME {start|stop|restart|force-reload}" >&2
        exit 3
        ;;
esac
