use IO::All;
use Data::Dumper;

use FindBin qw($Bin); # warn $Bin;

my $src = $Bin . '/sms.csv';
my @rows = io($src)->chomp->slurp; # warn Dumper \@rows;

my %t;

for (@rows) {
	next unless /^\d{4}-\d{2}-\d{2}/; # eg header row

	my ($code, $time) = ( split /\,/ )[12, -1]; # warn Dumper [$code, $time];

	$t{code}{$code}++;
	$t{time} += $time;
} # warn Dumper $t{code}; exit;

my %demog = map { split ': ' } <DATA>; # don't need chomp if $demog{$_} at end of output

printf "%11s %5s (%.1f%) %s", # code, count, %, decode(contains new-line)
	$_, $t{code}{$_}, 100 * $t{code}{$_} / scalar @rows, $demog{$_}
		for sort { $t{code}{$b} <=> $t{code}{$a} } keys %{ $t{code} };
printf "\nAverage response time: %.2f seconds for %s rows\n", $t{time} / @rows, scalar @rows;

__DATA__
DEMOG-0001: No Match
DEMOG-0007: Multiple matches found
DEMOG-0017: Superceding NHS number returned
DEMOG-0022: NHS Number of response record has been invalidated
DEMOG-0040: NHS number not verified
DEMOG-0042: NHS Number is not a new style number
DEMOG-9999: Generic Spine Service Error
SMSP-0000: Success
SMSP-0001: Input message validation error
SMSP-0002: Response message validation error
SMSP-0003: Data returned from local store, Spine unavailable
SMSP-9999: Generic Spine Mini Service Provider software failure
