package LIMS::Model::RequestAudit;

use strict;
use warnings;

use base 'LIMS::Model::Base';

# ------------------------------------------------------------------------------
sub get_audit_options {
    my $self = shift;
    my $args = shift || {};

    $args->{with_objects} = 'category';

    my $options = LIMS::DB::AuditRequestOption::Manager
        ->get_audit_request_options(%$args);

    return $options;
}

# ------------------------------------------------------------------------------
sub get_audit_categories {
    my $self = shift;
    my $args = shift || {};

    my $categories = LIMS::DB::AuditRequestCategory::Manager
        ->get_audit_request_categories(%$args);

    return $categories;

}

# ------------------------------------------------------------------------------
sub get_request_audit_option {
    my ($self, $id) = @_;
    
    my $option = LIMS::DB::AuditRequestOption->new(id => $id)->load;
    
    return $option;
}

# ------------------------------------------------------------------------------
sub get_request_audit_category {
    my ($self, $id) = @_;
    
    my $category = LIMS::DB::AuditRequestCategory->new(id => $id)->load;
    
    return $category;
}

# ------------------------------------------------------------------------------
sub update_request_audit_categories {
    my $self = shift;
    my $data = shift; # $self->debug( $code );

    my %args = ( class => 'AuditRequestCategory', data  => $data );
    
    return $self->update_object(\%args);    
}

# ------------------------------------------------------------------------------
sub update_request_audit_options {
    my $self = shift;
    my $data = shift; # $self->debug( $code );

    my %args = ( class => 'AuditRequestOption', data  => $data );
    
    return $self->update_object(\%args);    
}

1;
