package LIMS::DB::SampleType;

use strict;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'sample_types',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        specimen_type => { type => 'varchar', length => 50, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'specimen_type' ],

    relationships => [
        lab_section => {
            class      => 'LIMS::DB::LabSectionSampleType',
            column_map => { id => 'sample_type_id' },
            type       => 'one to many',
        },
        specimen => {
            class      => 'LIMS::DB::SpecimenSampleType',
            column_map => { id => 'sample_type_id' },
            type       => 'one to many',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('sample_types');

1;
